/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.ComprobanteAnulado;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloComprobantesAnulados;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class DialogoComprobanteAnulado
extends DialogoBase
implements VistaModelo<ComprobanteAnulado>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private ModeloComprobantesAnulados modeloValores;
    private List<ComprobanteAnulado> comprobantes;
    private ComprobanteAnulado modeloDatos;
    private Text txtNumeroSerie;
    private Text txtNumSerie2;
    private Text txtSecuencial1;
    private Text txtSecuencial2;
    private Text txtNumAutorizacion;
    private ComboViewer cvTipoComprobante;
    private final Periodo periodo;

    public DialogoComprobanteAnulado(IWorkbenchPartSite site, List<ComprobanteAnulado> comprobantes, Periodo periodo) {
        super(site);
        this.setShellStyle(80);
        this.comprobantes = comprobantes;
        this.periodo = periodo;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloComprobantesAnulados(this.periodo);
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(ComprobanteAnulado modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    public void procesarModeloDatos() {
        String codigoTipoComprobante = this.modeloDatos.getTipoComprobanteAnulado();
        ElementoNombreValor tipoComprobante = this.modeloValores.obtenerTipoComprobante(codigoTipoComprobante);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoComprobante, (Object)tipoComprobante);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (DialogoComprobanteAnulado.this.comprobantes.contains(DialogoComprobanteAnulado.this.modeloDatos)) {
                    resultado.fallarValidacion("El Comprobante Anulado ya se encuentra registrado");
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    protected Point getInitialSize() {
        return new Point(660, 320);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese la informaci\u00f3n del comprobante");
        this.setTitle("Comprobante Anulado");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(5, false));
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        GridData gd_label = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_label.widthHint = 125;
        label.setLayoutData((Object)gd_label);
        label.setText("Tipo de Comprobante");
        this.cvTipoComprobante = new ComboViewer(container, 8);
        this.cvTipoComprobante.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoComprobante = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoComprobante != null) {
                    DialogoComprobanteAnulado.this.modeloDatos.setTipoComprobanteAnulado((String)tipoComprobante.getValor());
                    DialogoComprobanteAnulado.this.modeloDatos.setDescripcionTipoComprobanteAnulado(tipoComprobante.getNombre());
                }
            }
        });
        Combo combo = this.cvTipoComprobante.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Composite composite = new Composite(container, 0);
        GridData gd_composite = new GridData(16384, 0x1000000, false, false, 5, 1);
        gd_composite.heightHint = 46;
        gd_composite.widthHint = 466;
        composite.setLayoutData((Object)gd_composite);
        Label lblNSerie = new Label(composite, 0);
        lblNSerie.setBounds(5, 10, 42, 15);
        lblNSerie.setText("N\u00b0 Serie");
        this.txtNumeroSerie = new Text(composite, 2048);
        this.txtNumeroSerie.setBounds(157, 15, 84, 28);
        this.txtNumeroSerie.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteAnulado.this.txtNumeroSerie.selectAll();
            }
        });
        this.txtNumeroSerie.setTextLimit(3);
        this.txtNumSerie2 = new Text(composite, 2048);
        this.txtNumSerie2.setBounds(248, 15, 93, 28);
        this.txtNumSerie2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteAnulado.this.txtNumSerie2.selectAll();
            }
        });
        this.txtNumSerie2.setTextLimit(3);
        Label label_1 = new Label(composite, 0);
        label_1.setText("Establecimiento");
        label_1.setBounds(157, 0, 84, 15);
        Label label_2 = new Label(composite, 0);
        label_2.setText("Punto de Emisi\u00f3n");
        label_2.setBounds(248, 0, 93, 15);
        Label lblSecuencial = new Label(container, 0);
        lblSecuencial.setText("Secuencial");
        Label lblDesde = new Label(container, 0);
        lblDesde.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDesde.setText("Desde");
        this.txtSecuencial1 = new Text(container, 2048);
        this.txtSecuencial1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteAnulado.this.txtSecuencial1.selectAll();
            }
        });
        this.txtSecuencial1.setTextLimit(9);
        GridData gd_txtSecuencial1 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtSecuencial1.widthHint = 75;
        this.txtSecuencial1.setLayoutData((Object)gd_txtSecuencial1);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblHasta = new Label(container, 0);
        GridData gd_lblHasta = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblHasta.widthHint = 50;
        lblHasta.setLayoutData((Object)gd_lblHasta);
        lblHasta.setText("Hasta");
        this.txtSecuencial2 = new Text(container, 2048);
        this.txtSecuencial2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteAnulado.this.txtSecuencial2.selectAll();
            }
        });
        this.txtSecuencial2.setTextLimit(9);
        GridData gd_txtSecuencial2 = new GridData(16384, 128, true, false, 1, 1);
        gd_txtSecuencial2.widthHint = 75;
        this.txtSecuencial2.setLayoutData((Object)gd_txtSecuencial2);
        new Label(container, 0);
        new Label(container, 0);
        Label lblNAutorizacion = new Label(container, 0);
        GridData gd_lblNAutorizacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNAutorizacion.widthHint = 100;
        lblNAutorizacion.setLayoutData((Object)gd_lblNAutorizacion);
        lblNAutorizacion.setText("N\u00b0 Autorizaci\u00f3n");
        this.txtNumAutorizacion = new Text(container, 2048);
        this.txtNumAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteAnulado.this.txtNumAutorizacion.selectAll();
            }
        });
        this.txtNumAutorizacion.setTextLimit(49);
        GridData gd_txtNumAutorizacion = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_txtNumAutorizacion.widthHint = 250;
        this.txtNumAutorizacion.setLayoutData((Object)gd_txtNumAutorizacion);
        new Label(container, 0);
        new Label(container, 0);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtNumeroSerieObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumeroSerie);
        IObservableValue establecimientoModeloDatosObserveValue = BeanProperties.value((String)"establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumeroSerieObserveWidget, establecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumSerie2ObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumSerie2);
        IObservableValue puntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumSerie2ObserveWidget, puntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtSecuencial1ObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSecuencial1);
        IObservableValue secuencialDesdeModeloDatosObserveValue = BeanProperties.value((String)"secuencialDesde").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtSecuencial1ObserveWidget, secuencialDesdeModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtSecuencial2ObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSecuencial2);
        IObservableValue secuencialHastaModeloDatosObserveValue = BeanProperties.value((String)"secuencialHasta").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtSecuencial2ObserveWidget, secuencialHastaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumAutorizacion);
        IObservableValue numAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumAutorizacionObserveWidget, numAutorizacionModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoComprobante.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoComprobante.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposDeComprobantesModeloValoresObserveList = PojoProperties.list((String)"tiposDeComprobantes").observe((Object)this.modeloValores);
        this.cvTipoComprobante.setInput((Object)tiposDeComprobantesModeloValoresObserveList);
        return bindingContext;
    }
}

